SET SESSION sql_mode='';
SET NAMES 'utf8mb4';

INSERT INTO `PREFIX_hook` (`id_hook`, `name`, `title`, `description`, `position`) VALUES
  -- https://github.com/PrestaShop/PrestaShop/pull/38371
  (NULL, 'actionDuplicateCartData','Cart duplication','This hook is triggered after all the cart related data has been duplicated', '1'),
  (NULL, 'actionObjectDuplicateAfter','After duplicating an object','This hook is called after duplicating an object by the core.', '1'),
  -- https://github.com/PrestaShop/PrestaShop/pull/38952
  (NULL, 'overrideImageLink','Override product image link','Allows to fully override the image URL returned by the getImageLink() method.', '1'),
  (NULL, 'adaptImageLink','Adapt product image link','Allows to dynamically modify the final image URL generated by getImageLink(), using a reference to the final value.', '1'),
  -- https://github.com/PrestaShop/PrestaShop/pull/38408
  (NULL, 'actionProductGetAttributesGroupsBefore','Triggers before getting product attributes groups','Allows to modify product attributes groups SQL query before they are retrieved from the database.', '1'),
  (NULL, 'actionProductGetAttributesGroupsAfter','Triggers after getting product attributes groups','Allows to modify product attributes groups after they are retrieved from the database.', '1'),
  -- https://github.com/PrestaShop/PrestaShop/pull/38480
  (NULL, 'actionPaymentModuleProductVarTplAfter','Triggers after product data is prepared for e-mail template','Allows to modify product data in e-mail template.', '1'),
  -- https://github.com/PrestaShop/PrestaShop/pull/38691
  (NULL, 'displayCartExtraProductInfo','Extra information in shopping cart product line','This hook adds extra information to the product lines, in the shopping cart', '1'),
  -- https://github.com/PrestaShop/PrestaShop/pull/38772
  (NULL, 'displayCustomerAccountTop','Customer account displayed in Front Office (Top part)','This hook displays new elements on the customer account page on Top', '1'),
  -- https://github.com/PrestaShop/PrestaShop/pull/39162
  (NULL, 'actionOrderHasBeenShipped', 'Called when checking if an order has been shipped', 'Allows modules to override or react to the hasBeenShipped() method of the Order class.', '1'),
  (NULL, 'actionOrderHasBeenDelivered', 'Called when checking if an order has been delivered', 'Allows modules to override or react to the hasBeenDelivered() method of the Order class.', '1')
ON DUPLICATE KEY UPDATE `title` = VALUES(`title`), `description` = VALUES(`description`);

ALTER TABLE `PREFIX_product_shop` ADD INDEX `shop_tax` (`id_shop`, `id_tax_rules_group`);
