<?php
namespace CleanUrlCategory\Router;

use Symfony\Component\Routing\RouterInterface;
use Symfony\Component\Routing\RouteCollection;
use Symfony\Component\Routing\Route;

class CleanRouterDecorator implements RouterInterface
{
    private $router;

    public function __construct(RouterInterface $router)
    {
        $this->router = $router;
    }

    public function getRouteCollection()
    {
        $collection = $this->router->getRouteCollection();

        // Replace category_rule path
        if ($collection->get('category_rule')) {
            $route = $collection->get('category_rule');
            $route->setPath('/{rewrite}'); // Remove {id}
            $route->setRequirement('rewrite', '[^/]+'); // Only slug
        }

        return $collection;
    }

    // Proxy all other methods to original router
    public function setContext($context) { $this->router->setContext($context); }
    public function getContext() { return $this->router->getContext(); }
    public function match($pathinfo) { return $this->router->match($pathinfo); }
    public function generate($name, $parameters = [], $referenceType = self::ABSOLUTE_PATH)
    { return $this->router->generate($name, $parameters, $referenceType); }
}
